/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.mapui.IVWSelectWorkflowItem;
import filenet.vw.toolkit.utils.mapui.VWAssociationLineRenderer;
import filenet.vw.toolkit.utils.mapui.VWBaseTextAnnotationUI;
import filenet.vw.toolkit.utils.mapui.VWLabelUI;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import filenet.vw.toolkit.utils.mapui.VWTextAttrUI;
import java.awt.AWTEventMulticaster;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.JComponent;

public class VWBaseAssociationUI
extends JComponent
implements IVWSelectWorkflowItem {
    private static int ARTIFICIAL_NAME_PIXEL_WIDTH = 150;
    private static int ARTIFICIAL_NAME_PIXEL_HEIGHT = 30;
    private static int MAX_DISPLAY_NAME = 20;
    protected VWAssociationDefinition m_associationDefinition = null;
    protected VWStepRouteColors m_stepRouteColors = null;
    protected boolean m_bFocus = false;
    protected boolean m_bSelect = false;
    protected VWAssociationLineRenderer m_renderer = null;
    protected VWBaseTextAnnotationUI m_srcTextAnnotation = null;
    protected Object m_targetItem = null;
    protected FocusListener m_focusListeners = null;
    protected VWLabelUI m_label = null;
    protected VWMapAttribs m_mapAttribs = null;

    public VWBaseAssociationUI(VWAssociationDefinition associationDefinition, VWBaseTextAnnotationUI srcTextAnnotation, Object targetItem, VWStepRouteColors stepRouteColors, VWMapAttribs mapAttribs) {
        VWDebug.nullCheck(associationDefinition);
        this.m_associationDefinition = associationDefinition;
        this.m_srcTextAnnotation = srcTextAnnotation;
        this.m_targetItem = targetItem;
        this.m_stepRouteColors = stepRouteColors;
        this.m_renderer = new VWAssociationLineRenderer(this);
        this.m_renderer.calcCoords();
        this.m_label = new VWLabelUI();
        this.m_mapAttribs = mapAttribs;
    }

    public VWAssociationDefinition getDefinition() {
        return this.m_associationDefinition;
    }

    public boolean captureFocus(Point loc) {
        this.setFocus(this.m_renderer.contains(loc));
        return this.getFocus();
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.m_focusListeners = AWTEventMulticaster.add(this.m_focusListeners, l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.m_focusListeners = AWTEventMulticaster.remove(this.m_focusListeners, l);
    }

    public boolean getFocus() {
        return this.m_bFocus;
    }

    public void setFocus(boolean bFocus) {
        if (this.m_bFocus != bFocus) {
            this.m_bFocus = bFocus;
            if (this.m_bFocus) {
                this.setSelect(true);
            }
            if (this.m_focusListeners != null) {
                if (this.m_bFocus) {
                    this.m_focusListeners.focusGained(new FocusEvent(this, 1004));
                } else {
                    this.m_focusListeners.focusLost(new FocusEvent(this, 1005));
                }
            }
        }
    }

    public boolean getSelect() {
        return this.m_bSelect;
    }

    public void setSelect(boolean bSelect) {
        if (this.m_bSelect != bSelect) {
            this.m_bSelect = bSelect;
            if (!bSelect) {
                this.setFocus(false);
            }
        }
    }

    public boolean contains(Point loc) {
        return this.m_renderer.contains(loc);
    }

    public Rectangle getBounds() {
        Rectangle rect = this.m_renderer.getBounds();
        Point point = this.getNamePoint();
        if (point != null) {
            Rectangle nameRect = new Rectangle(point.x - ARTIFICIAL_NAME_PIXEL_WIDTH / 2, point.y - ARTIFICIAL_NAME_PIXEL_HEIGHT / 2, ARTIFICIAL_NAME_PIXEL_WIDTH, ARTIFICIAL_NAME_PIXEL_HEIGHT);
            rect = rect.union(nameRect);
        }
        return rect;
    }

    public void recalcPosition() {
        this.m_renderer.calcCoords();
    }

    public Object getTargetItem() {
        return this.m_targetItem;
    }

    public boolean hasReferenceToItem(Object targetItem) {
        return targetItem == this.m_targetItem;
    }

    public VWBaseTextAnnotationUI getSourceTextAnnotation() {
        return this.m_srcTextAnnotation;
    }

    public VWStepRouteColors getStepRouteColors() {
        return this.m_stepRouteColors;
    }

    public void removeReferences() {
        this.m_associationDefinition = null;
        this.m_stepRouteColors = null;
        this.m_srcTextAnnotation = null;
        this.m_targetItem = null;
        this.m_focusListeners = null;
        this.m_label = null;
    }

    public void paintComponent(Graphics g) {
        try {
            if (this.m_mapAttribs.isTextAnnotationsVisible()) {
                this.m_renderer.calcCoords();
                this.m_renderer.paintComponent(g);
                this.createLabel();
                this.m_label.paintComponent(g, this.getCenterPoint(), true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void printComponent(Graphics2D g2, PageFormat pf, int pi, int wp, int hp) throws PrinterException {
        if (this.m_mapAttribs.isTextAnnotationsVisible()) {
            int row = pi / wp;
            int col = pi % wp;
            double iW = pf.getImageableWidth();
            double iH = pf.getImageableHeight();
            int pageX = (int)Math.round((double)col * iW);
            int pageY = (int)Math.round((double)row * iH);
            int pageX2 = pageX + (int)iW;
            int pageY2 = pageY + (int)iH;
            this.m_renderer.printComponent(g2, pageX, pageY);
            this.createLabel();
            this.m_label.printComponent(g2, this.getCenterPoint(), pageX, pageY, pageX2, pageY2, true);
        }
    }

    protected void createLabel() {
        try {
            this.m_label.removeAllAttributes();
            if (this.m_mapAttribs.isRouteNameVisible()) {
                String label = this.m_associationDefinition.getName();
                if (label != null && label.length() > MAX_DISPLAY_NAME) {
                    label = label.substring(0, MAX_DISPLAY_NAME - 1);
                }
                if (label != null && label.length() > 0) {
                    this.m_label.addAttribute(new VWTextAttrUI(label));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Point getNamePoint() {
        Point pt = null;
        if (this.m_associationDefinition != null && this.m_associationDefinition.getName() != null) {
            pt = this.m_renderer.getCenterPoint();
        }
        return pt;
    }

    private Point getCenterPoint() {
        Point pt = null;
        if (this.m_associationDefinition != null) {
            pt = this.m_renderer.getCenterPoint();
        }
        return pt;
    }
}

